@extends('layouts.app')

@section('title', 'Create Ticket')

@section('content')
<div class="ticket-create-page">
    <div class="container">
        <h1>Create New Ticket</h1>
        
        <form method="POST" action="{{ route('tickets.store') }}" enctype="multipart/form-data" class="ticket-form">
            @csrf
            
            <div class="form-group">
                <label for="subject">Subject</label>
                <input type="text" id="subject" name="subject" value="{{ old('subject') }}" required>
            </div>

            <div class="form-group">
                <label for="priority">Priority</label>
                <select id="priority" name="priority" required>
                    <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>Low</option>
                    <option value="medium" {{ old('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                    <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>High</option>
                </select>
            </div>

            <div class="form-group">
                <label for="description">Description</label>
                <textarea id="description" name="description" rows="10" required>{{ old('description') }}</textarea>
            </div>

            <div class="form-group">
                <label for="attachments">Attachments</label>
                <input type="file" id="attachments" name="attachments[]" multiple>
                <small>You can upload multiple files (Max 10MB per file)</small>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Create Ticket</button>
                <a href="{{ route('tickets.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection

